#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAX_N 200005
#define MAX_V MAX_N

int A[MAX_N];
int N;

int C_glob[MAX_V];

int B_vel; 
int B_broj;

int **B_cnt = NULL; 

int ru_g(double x) {
    int r=(int)x;
    if(x>(double)r){
        r++;
    }
    return r;
}

void pocni_blokove(int n) {
    B_vel = (int)sqrt(n);
    if(B_vel==0)B_vel=1;
    B_broj = ru_g((double)n / B_vel);
    
    B_cnt = (int**)malloc(B_broj * sizeof(int*));
    for(int i=0;i<B_broj;i++){
        B_cnt[i]=(int*)calloc(MAX_V, sizeof(int));
    }

    for(int i=1;i<=n;i++){
        C_glob[A[i]]++;
        int b_idx=(i-1)/B_vel;
        B_cnt[b_idx][A[i]]++;
    }
}

void menjaj(int x,int y) {
    int staro=A[x];
    
    C_glob[staro]--;
    C_glob[y]++;
    
    int b_idx=(x-1)/B_vel;
    B_cnt[b_idx][staro]--;
    B_cnt[b_idx][y]++;
    
    A[x]=y;
}

long long suma(int k) {
    if(k==0)return 0;
    
    int *P_cnt=(int*)calloc(MAX_V, sizeof(int)); 
    if(P_cnt==NULL)return -1; 
    
    int limit=k;
    int b_idx=(limit-1)/B_vel;
    
    for(int b=0;b<b_idx;b++){
        for(int v=1;v<MAX_V;v++){
            P_cnt[v]+=B_cnt[b][v];
        }
    }
    
    int s_idx=b_idx*B_vel+1;

    if(s_idx<=k){
        for(int i=s_idx;i<=k;i++){
            P_cnt[A[i]]++;
        }
    }
    
    long long s_konacna=0;
    for(int v=1;v<MAX_V;v++){
        int C_pre=P_cnt[v];
        int P=C_glob[v];
        
        if((C_pre%2)!=((P-C_pre)%2)){
            s_konacna+=v;
        }
    }
    
    free(P_cnt);
    return s_konacna;
}

void resi() {
    int Q;
    if(scanf("%d %d",&N,&Q)!=2)return;
    
    for(int i=1;i<=N;i++){
        if(scanf("%d",&A[i])!=1)return;
    }
    
    pocni_blokove(N);
    
    for(int q=0;q<Q;q++){
        int tip;
        if(scanf("%d",&tip)!=1)break;
        
        if(tip==1){
            int k;
            if(scanf("%d",&k)!=1)break;
            printf("%lld\n",suma(k));
        } else {
            int x,y;
            if(scanf("%d %d",&x,&y)!=2)break;
            menjaj(x,y);
        }
    }
    
    for(int i=0;i<B_broj;i++){
        free(B_cnt[i]);
    }
    free(B_cnt);
}

int main() {
    resi();
    return 0;
}